#include "settings.h"
#include "ui_settings.h"

Settings::Settings(GeneDrop *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    main_window=parent;
    ui->setupUi(this);
}

Settings::~Settings()
{
    delete ui;
}

void Settings::on_OKButton_clicked()
{
    this->setVisible(false);
}

void Settings::on_PedDefChoose_toggled(bool checked)
{
    if(checked)
    {
        main_window->params.change_ped_filename("pedigree.csv");
        ui->PedText->setText(QString::fromStdString(main_window->params.get_ped_filename()));
    }
}

void Settings::on_PedNameChoose_clicked(bool checked)
{
    if(checked)
    {
        main_window->params.change_ped_filename(QFileDialog::getOpenFileName(this, tr("Open File"), "pedigree.csv", tr("CSV Files (*.csv *.txt *xls *xlsx)")).toStdString());
        ui->PedText->setText(QString::fromStdString(main_window->params.get_ped_filename()));
    }
}

void Settings::on_LocDefChoose_toggled(bool checked)
{
    if(checked)
    {
        main_window->params.change_loc_filename("loci.csv");
        ui->LocText->setText(QString::fromStdString(main_window->params.get_loc_filename()));
    }
}

void Settings::on_LocNameChoose_clicked(bool checked)
{
    if(checked)
    {
        main_window->params.change_loc_filename(QFileDialog::getOpenFileName(this, tr("Open File"), "loci.csv", tr("CSV Files (*.csv *.txt *xls *xlsx)")).toStdString());
        ui->LocText->setText(QString::fromStdString(main_window->params.get_loc_filename()));
    }
}

void Settings::on_FouDefChoose_toggled(bool checked)
{
    if(checked)
    {
        main_window->params.change_fou_filename("founders.csv");
        ui->FouText->setText(QString::fromStdString(main_window->params.get_fou_filename()));
    }
}

void Settings::on_FouNameChoose_clicked(bool checked)
{
    if(checked)
    {
        main_window->params.change_fou_filename(QFileDialog::getOpenFileName(this, tr("Open File"), "founders.csv", tr("CSV Files (*.csv *.txt *xls *xlsx)")).toStdString());
        ui->FouText->setText(QString::fromStdString(main_window->params.get_fou_filename()));
    }
}
