#ifndef PARAMCLASS_H
#define PARAMCLASS_H

#include <string>

class parameters
{
    private:

    bool print_all; // True if output files to be produced after every generation
    int n_runs; //Number of runs
    std::string ped_filename;   //Name of pedigree file
    std::string loc_filename;   //Name of loci file
    std::string fou_filename;   //Name of founders file

    public:

    parameters()
    {
        print_all=false;
        n_runs=1;
        ped_filename="pedigree.csv";
        loc_filename="loci.csv";
        fou_filename="founders.csv";
    }

    //Getters/setters
    bool get_print_all()
    {
        return print_all;
    }

    int get_n_runs()
    {
        return n_runs;
    }

    std::string get_ped_filename()
    {
        return ped_filename;
    }

    std::string get_loc_filename()
    {
        return loc_filename;
    }

    std::string get_fou_filename()
    {
        return fou_filename;
    }

    void change_print_all(bool mode)
    {
        print_all=mode;
    }

    void change_n_runs(int num)
    {
        n_runs=num;
    }

    void change_ped_filename(std::string new_name)
    {
        ped_filename=new_name;
    }

    void change_loc_filename(std::string new_name)
    {
        loc_filename=new_name;
    }

    void change_fou_filename(std::string new_name)
    {
        fou_filename=new_name;
    }
};

#endif // PARAMCLASS_H
