#ifndef GENEDROP_H
#define GENEDROP_H

//These defines are super-important when using MinGW (but not in the documentation for some reason): they force boost_thread to link either statically or dynamically
//#define BOOST_THREAD_USE_LIB
//#define BOOST_THREAD_USE_DLL
//#define BOOST_THREAD_DYN_LINK

#include <boost/chrono.hpp>
#include <boost/thread.hpp>
#include <QWidget>
#include <string>

#include "paramclass.h"
#include "settings.h"

class Settings;

//Auto-generate code makes this namespace
namespace Ui {
class GeneDrop;
}

class GeneDrop : public QWidget
{
    Q_OBJECT
    
public:
    explicit GeneDrop(QWidget *parent = 0); //Standard QObject constructor
    ~GeneDrop();
    void print(std::string words);  //Overloaded functions for printing to main output box
    void print(std::stringstream &words);

    parameters params;    //Holds parameters to be passed to simulation
    Settings *settings_window;  //The window that pops up when "Input Settings" is pressed on the GUI

signals:
    void toprint(QString words);    //Emitted when "words" should be printed to the output window
    
private slots:
    //Self explanatory events (check the genedrop.ui form to see how the names correspond to certain GUI elements)
    void on_PrintCheck_toggled(bool checked);

    void on_RunInput_textChanged(const QString &arg1);

    void on_GoButton_clicked();

    void on_SettingsButton_clicked();

    void on_StopButton_clicked();

    void on_pushButton_clicked();

private:
    Ui::GeneDrop *ui;   //Pointer to GUI interface
    boost::thread *threadpt;    //Pointer to current running simulation thread
    void watcher(boost::thread *watchee, bool *flag);   //Watches for exceptions thrown in simulation thread
};


#endif // GENEDROP_H
