#include <boost/date_time.hpp>
#include <QMessageBox>

#include "genedrop.h"
#include "mainbody.h"
#include "ui_genedrop.h"
#include "settings.h"

GeneDrop::GeneDrop(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::GeneDrop)
{
    ui->setupUi(this);

    threadpt=NULL;
    settings_window=new Settings(this);
}

GeneDrop::~GeneDrop()
{
    delete ui;
}

void GeneDrop::on_PrintCheck_toggled(bool checked)
{
    if(checked)
    {
        params.change_print_all(true);
    }
    else
    {
        params.change_print_all(false);
    }
}

void GeneDrop::on_GoButton_clicked()
{
    static bool excep_flag=false;  //True if exception thrown by main body
    static bool lock=false;  //True if program already running, stops attempt to run twice

    if(lock)    //If already running don't start another instance
    {
        QMessageBox already_running_box;

        already_running_box.setText("The simulation is already running!");
        already_running_box.exec();
        return;
    }
    else
    {
        threadpt=new boost::thread(run_main_body, params.get_print_all(), params.get_n_runs(), params.get_ped_filename(), params.get_loc_filename(), params.get_fou_filename(), this, &lock, &excep_flag);
        boost::thread *excep_checker=new boost::thread(&GeneDrop::watcher, this, threadpt, &excep_flag);
    }
}

void GeneDrop::print(std::string words)
{
    QString output;
    boost::posix_time::ptime stamp;
    std::stringstream intermed;

    if(words!=" ")
    {
        stamp=boost::posix_time::second_clock::local_time();

        intermed<<"["<<to_simple_string(stamp)<<"] - "<<words;
        output=QString::fromStdString(intermed.str());
    }
    else
    {
        output=QString::fromStdString(words);
    }

    emit toprint(output);
}

void GeneDrop::print(std::stringstream &words)
{
    std::string formatted;

    formatted=words.str();
    words.str(std::string());
    words.clear();

    GeneDrop::print(formatted);
}


void GeneDrop::on_RunInput_textChanged(const QString &arg1)
{
    int new_runs;

    new_runs=arg1.left(arg1.indexOf('.')).toInt();
    params.change_n_runs(new_runs);
}

void GeneDrop::on_SettingsButton_clicked()
{
    static bool open=false;

    if(open)
    {
        return;
    }
    else
    {
        settings_window->show();
    }
}

void GeneDrop::on_StopButton_clicked()
{
    if(threadpt!=NULL)
    {
        threadpt->interrupt();
        print("Simulation halted.");
    }
    else
    {
        QMessageBox no_sim_box;

        no_sim_box.setText("No simulation is running!");
        no_sim_box.exec();
    }
}

void GeneDrop::on_pushButton_clicked()
{
    QMessageBox about_box;

    about_box.setText("<p align='center'>GeneDrop<br>Version: 1.1.1<br>Author: James Elderfield (james_elderfield@hotmail.com)<br>Maintainer: NIAB<br>Made for NIAB, Cambridge</p>");
    about_box.exec();
    return;
}

void GeneDrop::watcher(boost::thread *watchee, bool *flag)
{
    watchee->join();

    if(*flag==true)
    {
        QMessageBox excep_box;

        excep_box.setWindowTitle(":(");
        excep_box.setText("Something broke - Check the interface output for details.");
        excep_box.exec();
    }
    else
    {
        return;
    }
}
