#ifndef GENECLASSES_H
#define GENECLASSES_H

#include <QObject>
#include <string>
#include <vector>

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Class which represents an individual in a population
class plant
{
    private:
    std::string ID;		// Individual's ID
    std::string p1;		// First parent identifier
    std::string p2;		// Second parent identifier
    std::vector<int> genotype;		//Describes set of markers present/absent, each half of the array represents one homologous chromosome

    public:

    //Constructor sets up size of vector of markers
    plant(int n_loci)
    {
        genotype.resize(n_loci*2);
    }

    //A number of getters/setters to access the private members
    std::string get_ID()
    {
        return ID;
    }

    std::string get_p1()
    {
        return p1;
    }

    std::string get_p2()
    {
        return p2;
    }

    int get_genotype(int pos)
    {
        return genotype[pos];
    }

    void change_genotype(int locus, int value)
    {
        genotype[locus]=value;
    }

    void change_ID(std::string new_ID)
    {
        ID=new_ID;
    }

    void change_p1(std::string new_p1)
    {
        p1=new_p1;
    }

    void change_p2(std::string new_p2)
    {
        p2=new_p2;
    }
};

///////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////


//Class holding information about a particular locus
class locus
{
    private:
    std::string chrom;	// Name of the chromosome the locus is on
    std::string ID;	//Name of locus
    int pos;	//Numerical position of locus on chromosome
    double dist;	//Distance in centimorgans from start of chromosome

    public:

    //Getters and setters for private members

    std::string get_chrom()
    {
        return chrom;
    }

    std::string get_ID()
    {
        return ID;
    }

    int get_pos()
    {
        return pos;
    }

    double get_dist()
    {
        return dist;
    }

    void change_chrom(std::string new_chrom)
    {
        chrom=new_chrom;
    }

    void change_ID(std::string new_ID)
    {
        ID=new_ID;
    }

    void change_pos(int new_pos)
    {
        pos=new_pos;
    }

    void change_dist(double new_dist)
    {
        dist=new_dist;
    }
};

#endif // GENECLASSES_H
