#ifndef FILEIO_H
#define FILEIO_H

#include <boost/lexical_cast.hpp>
#include <boost/random.hpp>
#include <boost/tokenizer.hpp>
#include <exception>
#include <fstream>
#include <iostream>
#include <istream>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>

#include "biofunctions.h"
#include "geneclasses.h"
#include "genedrop.h"

//Works out how many founder lines there are
int get_num_founders(int *n_founders, std::string fou_filename, GeneDrop *ui);

//Works out how many generations there are in the pedigree
int get_num_gens(int *n_gens, std::string ped_filename, GeneDrop *ui);

//Works out how many runs need to be carried out
int get_num_runs(int *n_runs);

//Prints out an output file
int print_results(int run_num, int gen, int n_gens, int seed, int n_runs, int n_founders, int n_loci, int current_pop1, int current_pop2, std::vector<locus> loci, std::vector<plant> pop1, std::vector<plant> pop2, bool print_all, GeneDrop* ui);

//Works out which crosses need to be carried out this generation
int read_crosses(int gen, int *current_pop1, int *current_pop2, std::vector<plant> *pop1, std::vector<plant> *pop2, int n_loci, GeneDrop *ui, std::string ped_filename);

//Reads in the founder genotypes
int read_genotypes(int *current_pop1, std::vector<plant> *pop1, int n_loci, int *n_founders, boost::uniform_01<boost::mt19937>* rng, std::vector<locus> loci, GeneDrop* ui, std::string ped_filename, std::string fou_filename);

//Reads in information about the loci
int read_recom_fracs(std::vector<locus> *loci, int *n_loci, std::string loc_filename, GeneDrop *ui);

#endif // FILEIO_H
