#ifndef BIOFUNCTIONS_H
#define BIOFUNCTIONS_H

//These defines are super-important when using MinGW (but not in the documentation for some reason): they force boost_thread to link either statically or dynamically
//#define BOOST_THREAD_USE_LIB
//#define BOOST_THREAD_USE_DLL
//#define BOOST_THREAD_DYN_LINK

#include <boost/random.hpp>
#include <boost/thread.hpp>
#include <boost/tokenizer.hpp>
#include <stdlib.h>
#include <string>
#include <vector>

#include "fileio.h"
#include "geneclasses.h"
#include "genedrop.h"

//Utility function that switches the value of chromo_choose between 0 and 1
void chromo_switch(int* chromo_choose);

//Draws alleles from parents and passes them to offspring
int crossing(int round, boost::uniform_01<boost::mt19937>* rng, int current_pop1, int current_pop2, std::vector<plant> *pop1, std::vector<plant> *pop2, std::vector<locus> loci, int n_loci, GeneDrop* ui);

//Works out the recombination frequency between loci
double get_recom(locus locus1, locus locus2);

//Runs one round of simulation
int run_simulation(bool print_all, boost::uniform_01<boost::mt19937>* rng, int run_num, int n_gens, std::vector<locus> loci, int seed, int n_runs, int n_loci, int *n_founders, GeneDrop *ui, std::string ped_filename, std::string fou_filename);


#endif // BIOFUNCTIONS_H
